<?php

/**
 * Class that operate on table 'maccontrol'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-02-17 01:00
 */
class MaccontrolMySqlExtDAO extends MaccontrolMySqlDAO {

    public function queryByMacAndDeviceType($mac, $deviceType) {
        $sql = 'SELECT * FROM maccontrol WHERE mac = ? and deviceType= ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($mac);
        $sqlQuery->set($deviceType);
        return $this->getList($sqlQuery);
    }

    public function UpdateAllowRemoteAccess($value, $queryString) {
        $sql = 'update maccontrol set allowRemoteAccess = ' . $value . ' where 1 ' . $queryString;
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllMacDataUnionMacMovementmanage() {
        $sql = 'select temp.mac,temp.deviceType,maccontrol.allowRemoteAccess
                from
                ((SELECT mac,deviceType
                FROM maccontrol
                )union(
                SELECT mac,deviceType
                FROM movementmanage
                where mac != "")) as temp
                left join maccontrol on maccontrol.mac = temp.mac'; //union remove duplicate,union all doesnot
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllMacDataFromMovementmanage($queryString) {
        $sql = 'SELECT distinct mac,deviceType
                FROM movementmanage
                where mac != "" ' . $queryString; //union remove duplicate,union all doesnot
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllowedMac() {
        $sql = 'SELECT mac,deviceType
                FROM maccontrol
                where allowRemoteAccess = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function truncate() {
        $sql = 'TRUNCATE maccontrol';
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

}

?>